#!/bin/sh

PACKAGE_ID="com.starmicronics.starcputil"

# Check root privilege
if [ ${EUID:-${UID}} != 0 ]; then
    echo 'Permission denied'
    exit 1
fi

# Remove files
package_ids=`pkgutil --pkgs | grep com.starmicronics.star.*cputil.*`
if [ "x${package_ids}" != "x" ]; then
    for package_id in ${package_ids[@]}; do
        files=`pkgutil --files ${package_id} --only-files`
        for file in ${files[@]}; do
            rm -vrf /${file}
        done

        pkgutil --forget ${package_id}
    done
else
    echo "No related pkg for com.starmicronics.starcputil"
fi

cputil_packages=`ls -1 /usr/local/share | grep cputil-macos`

if [ "x${cputil_packages}" != "x" ]; then
    for cputil_package in ${cputil_packages[@]}; do
        if [ -e /usr/local/share/${cputil_package} ]; then
            rm -vdrf /usr/local/share/${cputil_package}
            echo 'Removed /usr/local/share/'${cputil_package}
        fi
    done
else
    echo "No related cputil-macos directory in /usr/local/share"
fi

if [ -e /etc/paths.d/cputil ]; then
    rm -vrf "/etc/paths.d/cputil"
    echo 'Removed /etc/paths.d/cputil'
else
    echo 'No /etc/paths.d/cputil file'
fi

echo "Finish uninstaller.sh!"
